/*
 * Decompiled with CFR 0.152.
 */
package egor.mastodon;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GarbageCollector {
    private static final Logger LOG = Logger.getLogger(GarbageCollector.class.getName());
    private static final int DEFAULT_DAYS = 14;

    public static void main(String[] args) {
        Options options = new Options();
        Option help = new Option("help", "print this message");
        Option hashes = Option.builder((String)"u").required().longOpt("unique-hash-db").argName("FILENAME").hasArg().desc("Content hash database").build();
        Option max = Option.builder((String)"d").longOpt("dead-line").argName("DAYS").type(Number.class).hasArg().desc("number of days, default: 14").build();
        Option dryrun = Option.builder((String)"n").longOpt("dry-run").desc("Read-only simulation mode").build();
        options.addOption(help).addOption(hashes).addOption(max).addOption(dryrun);
        try {
            int total;
            HashMap<UUID, Long> db;
            Path db_orig;
            String db_file;
            CommandLine cli;
            block37: {
                DefaultParser parser = new DefaultParser();
                cli = parser.parse(options, args);
                if (cli.hasOption(help.getOpt())) {
                    GarbageCollector.help(options);
                    return;
                }
                db_file = cli.getOptionValue(hashes.getOpt());
                db_orig = Paths.get(db_file, new String[0]);
                db = new HashMap<UUID, Long>();
                total = 0;
                if (Files.exists(db_orig, new LinkOption[0])) {
                    long days = cli.hasOption(max.getOpt()) ? (long)((Number)cli.getParsedOptionValue(max.getOpt())).intValue() : 14L;
                    long deadline = System.currentTimeMillis() / 1000L - days * 25L * 3600L;
                    try (LineNumberReader r = new LineNumberReader(new BufferedReader(new InputStreamReader(new GZIPInputStream(Files.newInputStream(db_orig, new OpenOption[0])))));){
                        String line;
                        while ((line = r.readLine()) != null) {
                            int delim = line.indexOf(32);
                            if (delim <= 0) continue;
                            UUID item = UUID.fromString(line.substring(0, delim));
                            Long date = Long.parseUnsignedLong(line.substring(delim + 1));
                            ++total;
                            if (date <= deadline) continue;
                            db.put(item, date);
                        }
                        break block37;
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, "cannot read db-hash file " + db_file, ex);
                        return;
                    }
                }
                LOG.warning(db_orig + " does not exist yet");
                return;
            }
            LOG.log(Level.INFO, "Statuses total: {0}, live: {1}, to-be-removed: {2}, saving...", new Object[]{total, db.size(), total - db.size()});
            if (cli.hasOption(dryrun.getOpt())) {
                LOG.log(Level.INFO, "dry-run mode ends");
                return;
            }
            Path db_new = Paths.get(db_file + ".new", new String[0]);
            try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(Files.newOutputStream(db_new, new OpenOption[0]))));){
                for (Map.Entry item : db.entrySet()) {
                    w.write(((UUID)item.getKey()).toString());
                    w.write(32);
                    w.write(((Long)item.getValue()).toString());
                    w.newLine();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "cannot write db-hash file " + db_new.toString() + ".new", ex);
                return;
            }
            try {
                Files.move(db_new, db_orig, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "cannot replace " + db_orig.toString() + " with " + db_new.toString() + " do it yourselves, please", e);
            }
        }
        catch (ParseException ex) {
            GarbageCollector.help(options);
        }
    }

    private static void help(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(Process.class.getName(), options, true);
    }
}

