/*
 * Decompiled with CFR 0.152.
 */
package egor.mastodon;

import com.google.gson.Gson;
import com.sys1yagi.mastodon4j.MastodonClient;
import com.sys1yagi.mastodon4j.api.Scope;
import com.sys1yagi.mastodon4j.api.entity.auth.AccessToken;
import com.sys1yagi.mastodon4j.api.entity.auth.AppRegistration;
import com.sys1yagi.mastodon4j.api.exception.Mastodon4jRequestException;
import com.sys1yagi.mastodon4j.api.method.Apps;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Register {
    private static final Logger LOG = Logger.getLogger(Register.class.getName());

    public static void main(String[] args) {
        Options options = new Options();
        Option help = new Option("help", "print this message");
        Option home = Option.builder((String)"h").required().longOpt("home").argName("HOSTNAME").hasArg().desc("Mastodon server hostname").build();
        Option usr = Option.builder((String)"u").required().longOpt("username").argName("USERNAME").hasArg().desc("Client username").build();
        Option psw = Option.builder((String)"p").required().longOpt("password").argName("PASSWORD").hasArg().desc("Client password").build();
        options.addOption(help).addOption(home).addOption(usr).addOption(psw);
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine cli = parser.parse(options, args);
            if (cli.hasOption(help.getOpt())) {
                Register.help(options);
                return;
            }
            Register.register(cli.getOptionValue(home.getOpt()), cli.getOptionValue(usr.getOpt()), cli.getOptionValue(psw.getOpt()));
        }
        catch (ParseException ex) {
            Register.help(options);
        }
    }

    private static void help(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(Process.class.getName(), options, true);
    }

    public static void register(String home, String username, String password) {
        MastodonClient client = new MastodonClient.Builder(home, new OkHttpClient.Builder(), new Gson()).build();
        Apps apps = new Apps(client);
        try {
            Scope scope = new Scope(new Scope.Name[]{Scope.Name.ALL});
            AppRegistration registration = (AppRegistration)apps.createApp("egothor-hhbmb", "urn:ietf:wg:oauth:2.0:oob", scope, "https://www.egothor.org/product/hahabimbi").execute();
            AccessToken accessToken = (AccessToken)apps.postUserNameAndPassword(registration.getClientId(), registration.getClientSecret(), scope, username, password).execute();
            System.out.printf("# save as your configuration file for later commands%nhome          = %s%nclient_id     = %s%nclient_secret = %s%naccess_token  = %s%ncreated_at    = %s%nscope         = %s%ntoken_type    = %s%n", registration.getInstanceName(), registration.getClientId(), registration.getClientSecret(), accessToken.getAccessToken(), accessToken.getCreatedAt(), accessToken.getScope(), accessToken.getTokenType());
        }
        catch (Mastodon4jRequestException e) {
            LOG.log(Level.WARNING, "registration", e);
        }
    }
}

