/*
 * Decompiled with CFR 0.152.
 */
package egor.mastodon;

import com.google.gson.Gson;
import com.sys1yagi.mastodon4j.MastodonClient;
import com.sys1yagi.mastodon4j.api.entity.Status;
import com.sys1yagi.mastodon4j.api.exception.Mastodon4jRequestException;
import com.sys1yagi.mastodon4j.api.method.Statuses;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import okhttp3.OkHttpClient;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Toot {
    private static final Logger LOG = Logger.getLogger(Toot.class.getName());

    public static void main(String[] args) {
        Options options = new Options();
        Option help = new Option("help", "print this message");
        Option defaults = Option.builder((String)"f").longOpt("config").argName("FILENAME").hasArg().desc("Configuration file").build();
        Option home = Option.builder((String)"h").longOpt("home").argName("HOSTNAME").hasArg().desc("Mastodon server hostname").build();
        Option client_id = Option.builder((String)"c").longOpt("client-id").argName("CLIENT_ID").hasArg().desc("Client id").build();
        Option access_token = Option.builder((String)"a").longOpt("access-token").argName("ACCESS_TOKEN").hasArg().desc("Client access token").build();
        Option hashes = Option.builder((String)"u").required().longOpt("unique-hash-db").argName("FILENAME").hasArg().desc("Content hash database").build();
        Option sensitive = Option.builder((String)"s").longOpt("sensitive").desc("Mark the media of the status as NSFW").build();
        Option spoiler_text = Option.builder((String)"t").longOpt("spoiler-text").argName("TEXT").hasArg().desc("Text to be shown as a warning before the actual content").build();
        Option visibility = Option.builder((String)"v").longOpt("visibility").argName("TYPE").hasArg().desc("Either private, unlisted or public (default)").build();
        options.addOption(help).addOption(defaults).addOption(home).addOption(client_id).addOption(access_token).addOption(hashes);
        options.addOption(sensitive).addOption(spoiler_text).addOption(visibility);
        try {
            HashMap<UUID, Long> db;
            Path db_orig;
            String db_file;
            Status.Visibility visibility_val;
            String access_token_s;
            String client_id_s;
            String home_s;
            CommandLine cli;
            block72: {
                DefaultParser parser = new DefaultParser();
                cli = parser.parse(options, args);
                if (cli.hasOption(help.getOpt())) {
                    Toot.help(options);
                    return;
                }
                home_s = null;
                client_id_s = null;
                access_token_s = null;
                if (cli.hasOption(defaults.getOpt())) {
                    String config_file = cli.getOptionValue(defaults.getOpt());
                    Properties prop = new Properties();
                    try (BufferedReader r = Files.newBufferedReader(Paths.get(config_file, new String[0]));){
                        prop.load(r);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, "I/O error on file " + config_file, ex);
                        return;
                    }
                    home_s = prop.getProperty("home");
                    client_id_s = prop.getProperty("client_id");
                    access_token_s = prop.getProperty("access_token");
                }
                if (cli.hasOption(home.getOpt())) {
                    home_s = cli.getOptionValue(home.getOpt());
                }
                if (cli.hasOption(client_id.getOpt())) {
                    client_id_s = cli.getOptionValue(client_id.getOpt());
                }
                if (cli.hasOption(access_token.getOpt())) {
                    access_token_s = cli.getOptionValue(access_token.getOpt());
                }
                if (home_s == null) {
                    LOG.severe("home parameter was not specified");
                    return;
                }
                if (client_id_s == null) {
                    LOG.severe("client_id parameter was not specified");
                    return;
                }
                if (access_token_s == null) {
                    LOG.severe("access_token parameter was not specified");
                    return;
                }
                visibility_val = Status.Visibility.Public;
                if (cli.hasOption(visibility.getOpt())) {
                    String param = cli.getOptionValue(visibility.getOpt());
                    switch (param.toLowerCase()) {
                        case "public": {
                            visibility_val = Status.Visibility.Public;
                            break;
                        }
                        case "private": {
                            visibility_val = Status.Visibility.Private;
                            break;
                        }
                        case "unlisted": {
                            visibility_val = Status.Visibility.Unlisted;
                            break;
                        }
                        default: {
                            LOG.severe(param + " visibility is not supported");
                            return;
                        }
                    }
                }
                db_file = cli.getOptionValue(hashes.getOpt());
                db_orig = Paths.get(db_file, new String[0]);
                db = new HashMap<UUID, Long>();
                if (Files.exists(db_orig, new LinkOption[0])) {
                    try (LineNumberReader r = new LineNumberReader(new BufferedReader(new InputStreamReader(new GZIPInputStream(Files.newInputStream(db_orig, new OpenOption[0])))));){
                        String line;
                        while ((line = r.readLine()) != null) {
                            int delim = line.indexOf(32);
                            if (delim <= 0) continue;
                            UUID item = UUID.fromString(line.substring(0, delim));
                            Long date = Long.parseUnsignedLong(line.substring(delim + 1));
                            db.put(item, date);
                        }
                        break block72;
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, "cannot read db-hash file " + db_file, ex);
                        return;
                    }
                }
                LOG.warning(db_orig + " does not exist yet, creating");
            }
            long ITEMS = db.size();
            try {
                Toot.upload(home_s, client_id_s, access_token_s, db, cli.hasOption(sensitive.getOpt()), cli.getOptionValue(spoiler_text.getOpt(), null), visibility_val);
            }
            catch (Throwable th) {
                if (ITEMS == (long)db.size()) {
                    LOG.warning("Mastodon import failed and nothing was added, just leaving");
                    return;
                }
                LOG.warning("Mastodon import failed, but some statuses passed OK, updating hash db with them");
            }
            LOG.info("Number of statuses added: " + ((long)db.size() - ITEMS));
            Path db_new = Paths.get(db_file + ".new", new String[0]);
            try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(Files.newOutputStream(db_new, new OpenOption[0]))));){
                for (Map.Entry<UUID, Long> item : db.entrySet()) {
                    w.write(item.getKey().toString());
                    w.write(32);
                    w.write(item.getValue().toString());
                    w.newLine();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "cannot write db-hash file " + db_new.toString() + ".new", ex);
                return;
            }
            try {
                Files.move(db_new, db_orig, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "cannot replace " + db_orig.toString() + " with " + db_new.toString() + " do it yourselves, please", e);
            }
        }
        catch (ParseException ex) {
            Toot.help(options);
        }
    }

    private static void help(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(Process.class.getName(), options, true);
    }

    public static void upload(String home, String client_id, String access_token, HashMap<UUID, Long> db, boolean sensitive, String spoiler_text, Status.Visibility visibility) throws Mastodon4jRequestException, IOException {
        MastodonClient client = new MastodonClient.Builder(home, new OkHttpClient.Builder(), new Gson()).accessToken(access_token).build();
        Statuses statuses = new Statuses(client);
        try (LineNumberReader r = new LineNumberReader(new BufferedReader(new InputStreamReader(System.in)));){
            String status;
            while ((status = r.readLine()) != null) {
                UUID hashMD5 = UUID.nameUUIDFromBytes(status.getBytes());
                if (db.containsKey(hashMD5)) {
                    LOG.log(Level.INFO, "already posted: {0}", status);
                    continue;
                }
                statuses.postStatus(status, null, null, sensitive, spoiler_text, visibility).execute();
                db.put(hashMD5, System.currentTimeMillis() / 1000L);
                LOG.log(Level.INFO, "newly posted: {0}", status);
            }
        }
        catch (Mastodon4jRequestException e) {
            LOG.log(Level.WARNING, "Mastodon", e);
            throw e;
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "I/O error", e);
            throw e;
        }
    }
}

